fn QuatToMat q =
(
	local wx
	local wy
	local wz
	local xx
	local yy
	local yz
	local xy
	local xz
	local zz
	local x2
	local y2
	local z2
	local m

	x2 = q.x + q.x
	y2 = q.y + q.y
	z2 = q.z + q.z

	xx = q.x * x2
	xy = q.x * y2
	xz = q.x * z2

	yy = q.y * y2
	yz = q.y * z2
	zz = q.z * z2

	wx = q.w * x2
	wy = q.w * y2
	wz = q.w * z2

	mxx = 1.0 - ( yy + zz )
	mxy = xy - wz
	mxz = xz + wy

	myx = xy + wz
	myy = 1.0 - ( xx + zz )
	myz = yz - wx

	mzx = xz - wy
	mzy = yz + wx
	mzz = 1.0 - ( xx + yy )

	mx = point3 mxx mxy mxz
	my = point3 myx myy myz
	mz = point3 mzx mzy mzz

	m = matrix3 mx my mz [ 0, 0, 0]
)
	
fn QuatMult q1 q2 =
(
	local x = q1.w * q2.x + q2.w * q1.x + q1.y * q2.z - q1.z * q2.y;
	local y = q1.w * q2.y + q2.w * q1.y + q1.z * q2.x - q1.x * q2.z;
	local z = q1.w * q2.z + q2.w * q1.z + q1.x * q2.y - q1.y * q2.x;
	local w = q1.w * q2.w - q1.x * q2.x - q1.y * q2.y - q1.z * q2.z;
	
	local out = quat x y z w
	out
)
	
fn MatrixTransformVector v mat =
(
	local x = v.x * mat.row1.x + v.y * mat.row2.x + v.z * mat.row3.x
	local y = v.x * mat.row1.y + v.y * mat.row2.y + v.z * mat.row3.y;
	local z = v.x * mat.row1.z + v.y * mat.row2.z + v.z * mat.row3.z;

	local out = point3 x y z
	out
)