utility TANImport "FAKK2 TAN Import" silentErrors:false
(
	global g_gameDataPath = ""
	global g_defaultGamePath = "C:\\FAKK2"
	
	local modelFilename
	local modelName
	local modelPath
	
	local appName = "FAKK2 TAN Import"
	
	group "About:"
	(
		label titleLabel "FAKK2 TAN Import v1.0"
		HyperLink addy "by Neil Davis" align:#center address:"mailto:senkusha@spintastics.com" color:(color 0 0 170) hoverColor:(color 170 0 0)
	)
	
	group "Import:"
	(
		button importButton "Import TAN..."
	)
	
	local recentFile
	
	fn AddRecentFile fname=
	(
		recentFile = fname
		ok
	)
	
	fn GetMostRecentPath=
	(
		if recentFile != undefined then
		(
			return getFileNamePath recentFile
		)
		else if g_gameDataPath != undefined then
		(
			return g_gameDataPath + "\\models\\"
		)
		else
		(
			return ""
		)
	)
	
	fn DoesFileReallyExist filename=
	(
		local temp = fopen filename "rb"
		if temp != undefined then
		(
			fclose temp
			true
		)
		else
		(
			false
		)
	)
	
	fn ShowError msg=
	(
		format "*** Error: %\n" msg
		messageBox msg title:appName;
		ok
	)
	
	fn FataError msg=
	(
		ShowError msg;
		throw (appName + ":" + msg)
	)
	
	fn Check condition msg=
	(
		if not condition do
		(
			if msg == unsupplied do msg = "Check failed"
			format "*** Check failed: %\n" msg
			FatalError msg
		)
	)
	
	fn SkipBytes bstream count=
	(
		local unknown
		case count of
		(
			2: unknown = ReadShort bstream #unsigned
			4: unknown = ReadLong bstream #unsigned
			default:
			(
				for i = 1 to count do
				(
					unknown = ReadByte bstream #unsigned
				)
			)
		)
	)
	
	fn ReadFixedString bstream fixedlen=
	(
		local str = ""
		for i = 1 to fixedLen do
		(
			local ch = ReadByte bstream #unsigned
			str += bit.intAsChar ch
			if ch == 0 then
			(
				SkipBytes bstream (fixedLen - i)
				exit
			)
		)
		str
	)
	
	fn LongToString num=
	(
		local str = ""
		for i = 1 to 4 do
		(
			str += bit.intAsChar (bit.and num 0xff)
			num /= 256
		)
		str
	)
	
	fn ToLowerCase instr=
	(
		local outstr = copy instr
		local upper = "ABCDEFGHIJKLMNOPQRSTUVWXYZ"
		local lower = "abcdefghijklmnopqrstuvwxyz"
		
		for i = 1 to outstr.count do
		(
			local pos = findString upper outstr[i]
			if pos != undefined do outstr[i] = lower[pos]
		)
		outstr
	)
	
	fn ToWindowsPath pakPath=
	(
		local winPath = "\\"
		for i = 1 to pakPath.count do
		(
			if pakPath[i] == "/" then
			(
				winPath += "\\"
			)
			else
			(
				winPath += pakPath[i]
			)
		)
		
		winPath
	)
	
	fn ChangeExt filename newExt=
	(
		(getFilenamePath filename) + (getFilenameFile filename) + newExt
	)
	
	fn GetDataPath=
	(
		if g_gameDataPath != undefined then
		(
			g_gameDataPath
		)
		else
		(
			g_defaultGameDataPath
		)
	)
	
	fn GetDataPathFilename filename=
	(
		local splitPath = filterString filename "\\/"
		
		if splitPath.count > 0 then
		(
			splitPath[splitPath.count]
		)
		else
		(
			""
		)
	)
	
	on TANImport open do
	(
		if g_gameDataPath == "" then
		(
			g_gameDataPath = g_defaultGameDataPath
		)
	)
	
	on TANImport close do
	(
	)
	
	struct TAN_Surface
	(
		ident,
		name,
		numFrames,
		numVerts,
		minLod,
		numTriangles,
		ofsTriangles,
		ofsCollapseMap,
		ofsSt,
		ofsXyzNormals,
		ofsEnd,
		
		offsetStart,
		
		fn LoadFromStream bstream=
		(
			offsetStart = ftell bstream
			
			ident 			= ReadLong bstream #unsigned
			name			= ReadFixedString bstream 64
			numFrames		= ReadLong bstream #unsigned
			numVerts		= ReadLong bstream #unsigned
			minLod			= ReadLong bstream #unsigned
			numTriangles	= ReadLong bstream #unsigned
			ofsTriangles	= ReadLong bstream #unsigned
			ofsCollapseMap	= ReadLong bstream #unsigned
			ofsSt			= ReadLong bstream #unsigned
			ofsXyzNormals	= ReadLong bstream #unsigned
			ofsEnd			= ReadLong bstream #unsigned
		),
		
		fn IsValid=
		(
			if ident != 541999444 then
			(
				return false
			)
			true
		),
		
		fn DebugOut=
		(
			format "TAN_Surface\n-----------\n"
			format "ident = %, name = %\n" ident name
			format "numFrames = %, numVerts = %, minLod = %, numTriangles = %\n" numFrames numVerts minLod numTriangles
			format "ofsTris = %, ofsCollapseMap = %, ofsSt = %, ofsXyzNormals = %, ofsEnd = %\n" \
				ofsTriangles ofsCollapseMap ofsSt ofsXyzNormals ofsEnd
		)
	)
	
	struct TAN_Triangle
	(
		indices,
		
		fn LoadFromStream bstream=
		(
			local v1 = ReadLong bstream #unsigned
			local v2 = ReadLong bstream #unsigned
			local v3 = ReadLong bstream #unsigned
			indices = [v3 + 1, v2 + 1, v1 + 1]
		)
	)
	
	struct TAN_XyzNormal
	(
		position,
		normal,
		
		fn LoadFromStream bstream scale offset=
		(
			local x = (ReadShort bstream #unsigned)
			local y = (ReadShort bstream #unsigned)
			local z = (ReadShort bstream #unsigned)
			normal = ReadShort bstream #unsigned
--			format "vert x: % y: % z% \n" x y z
			position = [x, y, z]
			position[ 1 ] = position[ 1 ] * scale[ 1 ] + offset[ 1 ]
			position[ 2 ] = position[ 2 ] * scale[ 2 ] + offset[ 2 ]
			position[ 3 ] = position[ 3 ] * scale[ 3 ] + offset[ 3 ]
			--	v[ 0 ]=(float)( (x - 32768) * scale[ 0 ] + offset[ 0 ] );
			--	v[ 1 ]=(float)( (y - 32768) * scale[ 1 ] + offset[ 1 ] );
			--	v[ 2 ]=(float)( (z - 32768) * scale[ 2 ] + offset[ 2 ] );
		),
		
		fn GetNormal=
		(
			local unpackAngle = 360.0 / 255.0
			
			local longitude = ((normal / 256 ) as float) * unpackAngle
			local latitude = ((bit.and normal 0xff) as float) * unpackAngle
			
			local norm = [0,0,0]
			norm.x = cos( longitude ) * sin( latitude )
			norm.y = sin( longitude ) * sin( latitude )
			norm.z = cos( latitude )
			
			norm
		),
		
		
		fn GetSize = 8
	)
	
	struct TAN_TexCoord
	(
		stu,
		
		fn LoadFromStream bstream=
		(
			local s = ReadFloat bstream
			local t = ReadFloat bstream
			
			stu = [s, -t, 0.0 ]
		)
	)
	
	struct TAN_TagName
	(
		name,
		
		fn LoadFromStream bstream=
		(
			name = ReadFixedString bstream 64
		)
	)
	
	struct TAN_TagData
	(
		origin,
		axisRow1,
		axisRow2,
		axisRow3,
		
		-- Internal
		matrix,

		fn LoadFromStream bstream = 
		(
			local x = ReadFloat bstream
			local y = ReadFloat bstream
			local z = ReadFloat bstream
			origin = [x, y, z]
			
			x = ReadFloat bstream
			y = ReadFloat bstream
			z = readFloat bstream
			axisRow1 = [x ,y ,z ]

			x = ReadFloat bstream
			y = ReadFloat bstream
			z = readFloat bstream
			axisRow2 = [x, y, z]
			
			x = ReadFloat bstream
			y = ReadFloat bstream
			z = ReadFloat bstream
			axisRow3 = [x, y, z]

			matrix = matrix3 axisRow1 axisRow2 axisRow3 origin
		),
		
		fn GetTranslation=
		(
			matrix.translationpart
		),
		
		fn GetRotation=
		(
			matrix.rotationpart
		),
		
		fn GetMatrix=
		(
			matrix
		)
	)
	
	struct TAN_Frame
	(
		bboxMin,
		bboxMax,
		scale,
		offset,
		delta,
		radius,
		frameTime,
		
		fn LoadFromStream bstream=
		(
			local x = ReadFloat bstream
			local y = ReadFloat bstream
			local z = ReadFloat bstream
			bboxMin = [x, y, z]
			
			x = ReadFloat bstream
			y = ReadFloat bstream
			z = ReadFloat bstream
			bboxMax = [x, y, z]
			
			x = ReadFloat bstream
			y = ReadFloat bstream
			z = ReadFloat bstream
			scale = [x, y, z]
			
			x = ReadFloat bstream
			y = ReadFloat bstream
			z = ReadFloat bstream
			offset = [x, y, z]
			
			x = ReadFloat bstream
			y = ReadFloat bstream
			z = ReadFloat bstream
			delta = [x, y, z]
			
			radius = ReadFloat bstream
			frameTime = ReadFloat bstream
		)
	)
		
	struct TAN_Header
	(
		ident,
		version,
		name,
		numFrames,
		numTags,
		numSurfaces,
		totalTime,
		totalDelta,
		ofsFrames,
		ofsSurfaces,
		ofsTags = #(),
		
		fn LoadFromStream bstream=
		(
			ident 		= ReadLong bstream #unsigned
			version 	= ReadLong bstream #unsigned
			name 		= ReadFixedString bstream 64
			numFrames 	= ReadLong bstream #unsigned
			numTags 	= ReadLong bstream #unsigned
			numSurfaces	= ReadLong bstream #unsigned
			totalTime	= ReadFloat bstream
			local x = ReadFloat bstream
			local y = ReadFloat bstream
			local z = ReadFloat bstream
			totalDelta = [ x, y, z ]
			ofsFrames	= ReadLong bstream #unsigned
			ofsSurfaces = ReadLong bstream #unsigned
			for tagNum = 1 to 16 do
			(
				local tagOfs = ReadLong bstream #unsigned
				append ofsTags tagOfs
			)
		),
		
		fn IsValid=
		(
			local identStr = LongToString ident
			if (LongToString ident) != "TAN " then
				return false
			if version != 0x2 then
			(
				ShowError "Incorrect version! Found " + version + " but should be 2"
				return false
			)
			if numFrames < 1 then
			(
				ShowError "TAN does not have any frames!"
				return false
			)
			true
		),
		
		fn DebugOut=
		(
			format "TAN_Header\n---------\n"
			format "ident: %, version: %, name: %\n" ident version name
			format "numFrames: %, numTags: %, numSurfaces: %\n" numFrames numTags numSurfaces
			
			ok
		)
	)
	
	struct TAN_Loader
	(
		bstream,
		
		header,
		frames,
		tagNames,
		tagData,
		tagObjects,
		surfaces,
		
		fn Open filename=
		(
			modelFilename = filename
			modelName = getFilenameFile filename
			modelPath = getFileNamePath filename
			bstream = fopen filename "rb"
			
			ok
		),
		
		fn Close=
		(
			fclose bstream
			ok
		),
		
		fn CreateTagObject name tanTag=
		(
			local verts = #([0, 0, 0], [0, -1, 0], [2, 0, 0])
			local tri = #([1, 2, 3])
			local tagObject = mesh name:name vertices:verts faces:tri pos:(tanTag.GetTranslation())
		
			in coordsys local tagObject.rotation = tanTag.GetRotation()
			
			tagObject
		),
		
		fn LoadSurface scale offset =
		(
			local surface = TAN_Surface()
			surface.LoadFromStream bstream
--			surface.DebugOut()
			
			if not surface.IsValid() then
			(
				return false
			)
			
			--Load tris
			fseek bstream (surface.offsetStart + surface.ofsTriangles) #seek_set
			
			local modelTris = #()
			for tris = 1 to surface.numTriangles do
			(
				local curTri = TAN_Triangle()
				curTri.LoadFromStream bstream
				
				append modelTris curTri.indices
			)
			
			--Load Tex Coords
			fseek bstream (surface.offsetStart + surface.ofsSt) #seek_set
			local modelTexCoords = #()
			for tex = 1 to surface.numVerts do
			(
				local curTC = TAN_TexCoord()
				curTC.LoadFromStream bstream
				append modelTexCoords curTC.stu
			)
			
			--create a mesh
			local maxMesh = mesh name:surface.name numVerts:surface.numVerts numFaces:surface.numTriangles \
									position:[0, 0, 0] scale:[1, 1, 1]
									
			-- add faces
			setMesh maxMesh faces:modelTris
			
			--add per-vertex tex-coords and texture faces
			setNumTVerts maxMesh surface.numVerts
			for i = 1 to surface.numVerts do
			(
				setTVert maxMesh i modelTexCoords[i]
			)
			
			buildTVFaces maxMesh
			for i = 1 to surface.numTriangles do
			(
				setTVFace maxMesh i modelTris[i]
			)
			
			modelTexCoords = undefined
			modelTris = undefined
			gc()
			
			--load baseFrame
			fseek bstream (surface.offsetStart + surface.ofsXyzNormals) #seek_set
			
			local baseFrameVerts = #()
			
			local curVertex = TAN_XyzNormal()
			for i = 1 to surface.numVerts do
			(
				curVertex.LoadFromStream bstream scale offset
				append baseFrameVerts curVertex.position
			)
			
			-- set base frame with no deltas
			setMesh maxMesh vertices:baseFrameVerts
			
			animate on
			(
				progressStart( "Loading " + surface.name )
				
				for curFrame = 1 to (header.numFrames - 1) do
				(	
					local frameOffset = curFrame * surface.numVerts * TAN_XyzNormal.GetSize()
					fseek bstream (surface.offsetStart + surface.ofsXyzNormals + frameOffset) #seek_set
						
					local curVertex = TAN_XyzNormal()
					for i = 1 to surface.numVerts do
					(
						curVertex.LoadFromStream bstream scale offset	
						baseFrameVerts[ i ] = curVertex.position
					)
					
					at time curFrame
					(
						for i = 1 to surface.numVerts do
						(
							meshop.SetVert maxMesh i baseFrameVerts[ i ]
						)
					)
					update maxMesh
					
					progressUpdate (100.0 * curFrame / header.numFrames )
				)
				progressEnd()
			)

			fseek bstream (surface.offsetStart +surface.ofsEnd) #seek_set

			
			gmaxMesh
		),
		
		fn LoadModel=
		(
			--Load TAN_Header
			fseek bstream 0 #seek_set
			
			header = TAN_Header()
			header.LoadFromStream bstream
--			header.DebugOut()
			
			if not header.IsValid() then
			(
				format "Invalid header, aboring.\n"
				return false
			)
			
			--Load frames
-- 			format "Loading Frames...\n"
			fseek bstream header.ofsFrames #seek_set
			frames = #()
			
			local curFrame = TAN_Frame()
			for frame = 1 to header.numFrames do
			(
				curFrame.LoadFromStream bstream
				
				append frames curFrame
			)
			
			--Load TagNames and TagData
--			format "Loading Tags...\n"
			tagNames = #()
			tagData = #()
			tagObjects = #()
			
			for i = 1 to header.numFrames do
			(
				local curTagName = TAN_TagName()
				
				for j = 1 to header.numTags do
				(
					fseek bstream header.ofsTags[ j ] #seek_set
					
					curTagName.LoadFromStream bstream
					append tagNames curTagName.name
				
					local curTag = TAN_TagData()
					curTag.LoadFromStream bstream
						
					append tagData curTag
					
					if i == 1 then
					(
						local tagObject = CreateTagObject tagNames[ j ] curTag
						append tagObjects tagObject
						
						in coordsys world tagObject.transform = curTag.GetMatrix()
						
						animate on
						(
							at time 0
							(
								in coordsys world tagObject.transform = curTag.GetMatrix()
							)
						)
					)
					else
					(
						animate on
						(
							at time (i-1)
							(
								in coordsys world tagObjects[j].transform = curTag.GetMatrix()
							)
						)
					)
				)
			)
					
--			for i = 1 to header.numFrames do
--			(
--				local curTagName = TAN_TagName()
--				local relativeTag
--				
--				for j = 1 to header.numTags do
--				(
--					fseek bstream header.ofsTags[ j ] #seek_set
--					
--					curTagName.LoadFromStream bstream
--					append tagNames curTagName.name
--				
--					local curTag = TAN_TagData()
--					curTag.LoadFromStream bstream
--						
--					append tagData curTag
--						
--					if i > 1 then
--					(
--						animate on
--						(
--							at time i
--							(
--								in coordsys world
--								(
--									tagObjects[ j ].transform = curTag.GetMatrix()
--								)
--							)
--						)
--					)
--					else
--					(
--						if curTag.isRelative then
--						(
--							relativeTag = j
--						)
--						
--						local tagObject = CreateTagObject tagNames[ j ] curTag
--						append tagObjects tagObject
--						
--						in coordsys world
--						(
--							tagObjects[ j ].transform = curTag.GetMatrix()
--						)
--							
--						animate on
--						(
--							at time 1
--							(
--								in coordsys world
--								(
--									tagObject.transform = curTag.GetMatrix()
--								)
--							)
--						)
--					)
--				)
			
--				format "Loaded tag: %\n" curTagName.name
--			)
			
			--Load surfaces
--			format "Loading surfaces...\n"
			surfaceList = #()
			fseek bstream header.ofsSurfaces #seek_set
			
			for surf = 1 to header.numSurfaces do
			(
				local newObject = LoadSurface frames[ 1 ].scale frames[ 1 ].offset
				append SurfaceList newObject
			)
			
--			format "Done Loading.\n"
			true
		)
	)
			
	on importButton pressed do
	(
		local modelFilename = getOpenFileName caption:"Import FAKK2 model" filename:(GetMostRecentPath()) \
					types:"FAKK2 TAN (*.tan)|*.tan|All Files (*.*)|*.*|"
		
		if modelFilename != undefined then
		(
			if DoesFileReallyExist modelFilename then
			(
				AddRecentFile modelFilename
				
				(
					local loader = TAN_Loader()
					loader.Open modelFilename
					loader.LoadModel()
					loader.Close()
				)
				
				max views redraw
			)
		)
	)
)
	
		